File: /docs/engineering/contracts/README.md

# Contracts

This folder contains the UI contracts for SaaS OS Free Edition.

Contracts define:

- Component purpose
- Props
- States (if applicable)
- Constraints
- Behavioral boundaries

If behavior is not defined in a contract,
it must not be implemented.

---

## Authority

For Free Edition:

- The contract documents in this folder are authoritative.
- Generated code must follow these files exactly.
- If a conflict exists between code and contract, the contract wins.

Contracts define meaning.
Code is an implementation.

---

## Usage Rules

- Do not invent props, states, or variants.
- Do not infer behavior from layout or visuals.
- Do not simplify or reinterpret contract intent.
- Do not introduce implicit logic.

If something is not documented, it does not exist.

---

## AI / Cursor Usage

When using Cursor:

- Always reference the relevant contract file explicitly.
- Generate code that conforms exactly to documented props and constraints.
- Do not guess missing requirements.
- If ambiguity exists, stop and request clarification.

---

## Scope (Free Edition)

SaaS OS Free Edition includes contracts for:

- ui-button
- ui-input

Advanced component contracts and architectural enforcement
are available in SaaS OS Pro.

---

## Important Principle

Contracts are specifications.

They are not suggestions.

All UI code must be traceable to a documented contract.